############### ###############
## F_H2_A_log_members_total_after
## Project: CBO
## Author: Kamil Kouhen
## Date of creation: 23/06/2022
############### ###############

#Uniform Path
path <- here("Output/For Publication/Figures/F_")

  ##Distribution (displaying percentage change instead of number of member at the time of interview)
  forplot <- CBO_groups_final %>%
    rowwise() %>% 
    mutate(todrop_pcchange = ifelse(!is.na(A_log_members_total_after), ((B_members_total_after - B_members_total_before)/B_members_total_before), NA)) %>% #Adding conditions to remove the two observations that were put as NA in log transformation because numbers did not make sense (total < or = 0)
    ungroup()
  
  ggplot(forplot %>% drop_na(todrop_pcchange),
         aes(x = todrop_pcchange*100)) + 
    geom_histogram(binwidth = 1) + 
    labs(
      x = "Percentage change in the number of CBO members (from start of 2020 to 2021 Q3)", 
      y = "Number of CBOs"
    ) +
    theme_minimal() +
    theme(text = element_text(size=11, family="Times")) +
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm"))
  
  ggsave(width = 7, height = 3, filename = paste0(path, "H2_", "A_log_members_total_after.png"), device = png,  dpi=200)
  rm(forplot)


